#include <iostream>
#include <vector>
#include <unordered_map>

enum BloodTypes
{
	O = 0,
	A = 1,
	B = 2,
	AB = 3,
	INVALID = -1
};

const BloodTypes allowed_map[4][4] = 
{
	{BloodTypes::O, BloodTypes::INVALID, BloodTypes::INVALID, BloodTypes::INVALID},
	{BloodTypes::A, BloodTypes::O, BloodTypes::INVALID, BloodTypes::INVALID},
	{BloodTypes::B, BloodTypes::O, BloodTypes::INVALID, BloodTypes::INVALID},
	{BloodTypes::AB, BloodTypes::A, BloodTypes::B, BloodTypes::O}
};

const std::unordered_map<std::string, BloodTypes> btmap = 
{
	{ "O", BloodTypes::O },
	{ "A", BloodTypes::A },
	{ "B", BloodTypes::B },
	{ "AB", BloodTypes::AB }
};

class Patient
{
public:
	BloodTypes blood_type;
	int recv_units[4];
	int req_units;

	Patient(std::string bt, int ru) : blood_type {btmap.at(bt)}, req_units {ru}, recv_units {0, 0, 0, 0} {}

	bool try_give_blood(int units[])
	{
		req_units--;		
	
		for(int i = 0; i < 4; i++)
		{
			int index = allowed_map[blood_type][i];
			
			if(index == BloodTypes::INVALID)
				continue;

			if(units[index] > 0)
			{
				units[index]--;
				recv_units[index]++;
				return true;
			}
		}

		return false;
	}
};

inline int stop()
{
	std::cout << "nemoguce\n";
	return 0;
}

int main()
{
	int n;
	int num_o, num_a, num_b, num_ab;
	int units[4];

	std::vector<Patient> patients;

	std::cin >> n;
	std::cin >> units[0] >> units[1] >> units[2] >> units[3];
	
	for(int i = 0; i < n; i++)
	{
		std::string bt;
		int ru;

		std::cin >> bt >> ru;

		patients.emplace_back(bt, ru);
	}

	for(auto &patient: patients)
	{
		while(patient.req_units > 0)
		{
			bool status = patient.try_give_blood(units);
	
			if(!status)
			{
				std::cout << "nemoguce\n";
				return 0;
			}
		}
	}

	std::cout << "moguce\n";

	for(const auto &patient : patients)
	{
		for(int i = 0; i < 4; i++)
			std::cout << patient.recv_units[i] << " ";

		std::cout << "\n";
	}

	return 0;
}